--appmain must define these:
appname="BottleRockets"
appversion=0.1

function appload(playerName)
  love.graphics.setMode( 640, 480 )
  startGame(playerName)
end

function appupdate(dt)
  tickGame(dt)
end

function appdraw()
  drawGame()
end
--------------------------------------
local MODE_START = 0
local MODE_INPUT_BOTTLE_SIZE = 1
local MODE_INPUT_WATER_SIZE = 2
local MODE_INPUT_NOZZLE_SIZE = 3
local MODE_INPUT_PRESSURE = 4
local MODE_LAUNCH = 5

local playerList={} -- name,x,y,col{rgb},
local worldSize = 400
local playerSize = 15
local gameFont
local mode = MODE_START
local minBottleSize = 100
local maxBottleSize = 2000
local currentBottleSize = minBottleSize
local minWaterSize = 10
local maxWaterSize = maxBottleSize
local currentWaterSize = minWaterSize
local minNozzleSize = 10
local maxNozzleSize = 40
local currentNozzleSize = minNozzleSize
local currentPressure = 0
local minPressure = 1
local maxPressure = 100
local debounce=false
local lastHeight = 0
local gravity = 9.8
local velocity = 0
local friction = 0.01
local inputValue = 0

function startGame(playerName)
  assert(playerName)
  gameFont = love.graphics.newFont(love._vera_ttf, 12)

  addPlayer(playerName,320,400,randomColour())
end

function tickGame(dt)
  if playerList[1] ~= nil then
    if mode < MODE_INPUT_PRESSURE then
      if love.keyboard.isDown("return") then
        if mode == MODE_START then mode = MODE_INPUT_BOTTLE_SIZE end
        inputValue = inputValue + 33 * dt
        if inputValue > 100 then inputValue = 100 end
        if mode == MODE_INPUT_BOTTLE_SIZE then
          local inputVal = minBottleSize + ((maxBottleSize-minBottleSize)/100) * inputValue
          currentBottleSize = inputVal
        elseif mode == MODE_INPUT_WATER_SIZE then
          local inputVal = minWaterSize + ((maxWaterSize-minWaterSize)/100) * inputValue
          currentWaterSize = inputVal
        end
      elseif inputValue > 0 then
        if mode == MODE_INPUT_BOTTLE_SIZE then
          inputValue = minBottleSize + ((maxBottleSize-minBottleSize)/100) * inputValue
          currentBottleSize = inputValue
          maxWaterSize = currentBottleSize
          currentWaterSize = minWaterSize
          mode = MODE_INPUT_WATER_SIZE
        elseif mode == MODE_INPUT_WATER_SIZE then
          inputValue = minWaterSize + ((maxWaterSize-minWaterSize)/100) * inputValue
          currentWaterSize = inputValue
          --Calculate launch pressure (more water&largernozzle=higher pressure)
          maxPressure = 100 + ((currentBottleSize/currentWaterSize)*(currentBottleSize/200))
          currentPressure = 0
          --mode = MODE_INPUT_NOZZLE_SIZE
        --elseif mode == MODE_INPUT_NOZZLE_SIZE then
          --inputValue = minNozzleSize + ((maxNozzleSize-minNozzleSize)/100) * inputValue
          --currentNozzleSize = inputValue
          mode = MODE_INPUT_PRESSURE
        end
        inputValue=0
      end
    end
    if mode == MODE_INPUT_PRESSURE then
      if love.keyboard.isDown("return") then
        if debounce == false then
          currentPressure = currentPressure + 5
          debounce = true
        end
      else
        debounce = false
      end
      if currentPressure >= maxPressure then
        currentPressure = maxPressure
        lastHeight = 0
        mode = MODE_LAUNCH
        log("---------------------------------------------------------------------")
      else
        currentPressure = currentPressure - (currentPressure*0.2*dt)
        if currentPressure < minPressure then currentPressure = 0 end
      end 
    elseif mode == MODE_LAUNCH then
      local force = 0
      if currentWaterSize > 0 and currentPressure > minPressure then
        --calculate amount of water ejected by pressure
        local ejected = currentNozzleSize * currentPressure * 5 * dt
        if ejected < 0 then ejected = 0 end
        if ejected > currentWaterSize then ejected = currentWaterSize end
        --calculate force on bottle with remaining water by released water as acceleration
        if ejected <= 0 then
          force = 0
        else
          force = ((ejected * (currentPressure)) / (currentWaterSize+(currentBottleSize/300)))*30
          --force = (ejected / (currentWaterSize+(currentBottleSize/300))) * currentPressure * 10
        end
        --calculate remaining water in bottle
        currentWaterSize = currentWaterSize - ejected
        if currentWaterSize < 1 then currentWaterSize = 0 end
        --Calculate drop in pressure
        currentPressure = currentPressure - (currentPressure*currentNozzleSize*2*dt)
        if currentPressure < minPressure then currentPressure = 0 end
        log(ejected.." "..currentPressure.." "..currentWaterSize.." "..force)
      else
        if currentPressure > minPressure then currentPressure = minPressure end
      end
      --apply gravity
      local acceleration = -force + gravity
      --apply acceleration to velocity
      velocity = velocity + (acceleration * dt)
      if velocity > 0 then
        velocity = velocity - (velocity * friction * dt)
      elseif velocity < 0 then
        velocity = velocity + (velocity * friction * dt)
      end
      --apply velocity to position
      playerList[1][3] = playerList[1][3] + (velocity * dt)
      if (400 - playerList[1][3]) > lastHeight then lastHeight = (400 - playerList[1][3]) end
      if lastHeight > playerList[1][5] then playerList[1][5] = lastHeight end
      if playerList[1][3] >= 400 and currentPressure <= minPressure then
        log("Max height " ..lastHeight)
        playerList[1][3]=400
        velocity=0
        currentBottleSize=minBottleSize
        currentWaterSize=minWaterSize
        mode = MODE_INPUT_BOTTLE_SIZE
        textInputOn()
      end
    end
    if love.keyboard.isDown("r") then--reset
      playerList[1][3]=400
      velocity=0
      currentPressure=0
      currentBottleSize=minBottleSize
      currentWaterSize=minWaterSize
      mode = MODE_INPUT_BOTTLE_SIZE
      textInputOn()
    end
    local msg = string.format("%s %d %d %d %d %d %d",playerList[1][1], playerList[1][2], playerList[1][3], playerList[1][4][1], playerList[1][4][2], playerList[1][4][3], playerList[1][5])
    clientPushMessage("UPDATE",msg)
  end
  
  local msg = clientPopMessage()
  while msg ~= nil do
    if msg[1] == "UPDATE" then
      local data = string.format("%s",msg[2])
      local name, params = data:match("^(%S*) (.*)")
      local xs,ys,rs,gs,bs,ss = params:match("^(%-?[%d.e]*) (%-?[%d.e]*) (%-?[%d.e]*) (%-?[%d.e]*) (%-?[%d.e]*) (%-?[%d.e]*)")
      local x = tonumber(xs)
      local y = tonumber(ys)
      local r = tonumber(rs)
      local g = tonumber(gs)
      local b = tonumber(bs)
      local s = tonumber(ss)
      local found = false
      for k,v in pairs(playerList) do
        if name == v[1] and k~=1 then
          found=true
          --v[2]=x --x is maintained locally!
          v[3]=y
          v[5]=s
        end
      end
      if found == false then
        addPlayer(name,x,y,{r,g,b})
      end
    end
    msg = clientPopMessage()
  end
end

function drawGame()
  love.graphics.setFont(gameFont) 
  love.graphics.setColor( 255,255,255 )
	if mode == MODE_INPUT_BOTTLE_SIZE or mode == MODE_START then
	  love.graphics.setColor( 0,255,0 )
    love.graphics.print("Hold 'return' to set bottle size", 0, 450);
  elseif mode == MODE_INPUT_WATER_SIZE then
    love.graphics.setColor( 0,255,0 )
    love.graphics.print("Hold 'return' to add water", 0, 450);
  elseif mode == MODE_INPUT_PRESSURE then
    love.graphics.setColor( 0,255,0 )
    love.graphics.print("Hammer 'return' to add pressure!", 0, 450);
  end 
  love.graphics.setColor( 0,255,0 )
  love.graphics.print("Press 'r' to reset", 450, 450);
  love.graphics.setColor( 255,255,255 )
  local text = string.format("Last height:%dm",lastHeight)
  love.graphics.print(text, 0, 15);
  	
  --local text = string.format("Bottle:%dml  Water:%dml  Nozzle:%dmm  Pressure:%d(%d)  Last Height:%dm",currentBottleSize,currentWaterSize,currentNozzleSize,currentPressure,maxPressure,lastHeight)
  --love.graphics.print(text, 0, 0);
  love.graphics.setColor( 255,255,255 )
  love.graphics.line(0,400,640,400)
  for k,v in pairs(playerList) do
    local bottleSize = 1000
    local waterSize = 500
    if k == 1 then
      bottleSize = currentBottleSize
      waterSize = currentWaterSize
    end
    love.graphics.setColor( 255,255,255 )
    love.graphics.rectangle("line",v[2],v[3]-(bottleSize/25),playerSize,(bottleSize/25))
    if currentWaterSize > 0 then
      love.graphics.setColor( 0,0,255 )
      love.graphics.rectangle("fill",v[2]+1,(v[3]-((waterSize/25)-2)),playerSize-4,(waterSize/25)-4)
    end
    if k == 1 then
      if mode == MODE_INPUT_PRESSURE then
        love.graphics.setColor( 255,255,255 )
        love.graphics.rectangle("line",v[2]+(playerSize+5),v[3]-(maxPressure),playerSize/2,maxPressure)
        if currentWaterSize > 0 then
          love.graphics.setColor( 255,255,0 )
          love.graphics.rectangle("fill",v[2]+(playerSize+5)+1,v[3]-(maxPressure-currentPressure),(playerSize/2)-2,maxPressure-currentPressure)
        end
      end
    end
    love.graphics.setColor( v[4][1],v[4][2],v[4][3] )
    love.graphics.print(v[1], v[2], v[3]);
  end
  
  local bestK=1
  local bestHeight=0
  for k,v in pairs(playerList) do
    if v[5] > bestHeight then
      bestK=k
      bestHeight=v[5]
    end
  end
  for k,v in pairs(playerList) do
    if k == bestK then
      love.graphics.setColor( 0,255,0 )
    else
      love.graphics.setColor( 255,255,255 )
    end
    local text = string.format("%s %dm",v[1],v[5])
    love.graphics.print(text, 500, 0+(k*15));
  end
end

function addPlayer(name,x,y,col)
  log("ADDPLAYER: "..name.." "..x.." "..y.." "..col[1].." "..col[2].." "..col[3])
  local player = {name,x,y,col,0}
  table.insert(playerList,player)
  
  --x positions maintained locally
  local count=0
  for k,v in pairs(playerList) do
    count = count + 1
  end
  spacing = 640 / (count + 2)
  for k,v in pairs(playerList) do
    playerList[k][2] = k * spacing
  end

end

function randomColour()
  local col = {0,0,0}
  local red = (math.random(14) + 1) * 16
  local green = (math.random(14) + 1) * 16
  local blue = (math.random(14) + 1) * 16
  col = {red,green,blue}
  return col
end

